/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid.ranged;

import dev.xkmc.mob_weapon_api.api.projectile.CrossbowUseContext;
import dev.xkmc.mob_weapon_api.api.projectile.ICrossbowBehavior;
import dev.xkmc.mob_weapon_api.api.projectile.ProjectileWeaponUser;
import dev.xkmc.mob_weapon_api.registry.WeaponRegistry;
import dev.xkmc.modulargolems.content.entity.goals.GolemMeleeGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemRangedAttackGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemUser;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class GolemCrossbowAttackGoal
extends GolemRangedAttackGoal {
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private int attackDelay;

    public GolemCrossbowAttackGoal(HumanoidGolemEntity mob, GolemMeleeGoal melee, double speed, float radius) {
        super(mob, melee, speed, radius);
    }

    @Override
    public boolean mayActivate(HumanoidGolemEntity golem, ItemStack stack) {
        Optional weapon = WeaponRegistry.CROSSBOW.get((LivingEntity)this.mob, stack);
        if (weapon.isEmpty()) {
            return false;
        }
        return ((ICrossbowBehavior)weapon.get()).hasProjectile((ProjectileWeaponUser)new GolemUser(this.mob, null), stack) || ((ICrossbowBehavior)weapon.get()).hasLoadedProjectile((LivingEntity)this.mob, stack);
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.mob.m_6136_(false);
        this.attackDelay = 0;
    }

    public void m_8037_() {
        this.doMelee();
        this.strafing();
        LivingEntity target = this.mob.m_5448_();
        ItemStack stack = this.mob.m_21120_(this.mob.getWeaponHand());
        Optional weapon = WeaponRegistry.CROSSBOW.get((LivingEntity)this.mob, stack);
        if (weapon.isEmpty()) {
            return;
        }
        GolemUser user = new GolemUser(this.mob, target);
        ICrossbowBehavior behavior = (ICrossbowBehavior)weapon.get();
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            if (behavior.hasLoadedProjectile((LivingEntity)this.mob, stack)) {
                this.crossbowState = CrossbowState.CHARGED;
                this.mob.m_6136_(false);
            } else if (behavior.hasProjectile((ProjectileWeaponUser)user, stack)) {
                if (behavior.chargeTime((LivingEntity)this.mob, stack) <= 0) {
                    if (((ICrossbowBehavior)weapon.get()).tryCharge((ProjectileWeaponUser)user, stack)) {
                        this.crossbowState = CrossbowState.CHARGED;
                    }
                } else {
                    this.mob.m_6672_(this.mob.getWeaponHand());
                    this.crossbowState = CrossbowState.CHARGING;
                    this.mob.m_6136_(true);
                }
            }
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            if (!this.mob.m_6117_()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if (this.mob.m_21252_() >= ((ICrossbowBehavior)weapon.get()).chargeTime((LivingEntity)this.mob, stack)) {
                this.mob.m_21253_();
                if (((ICrossbowBehavior)weapon.get()).tryCharge((ProjectileWeaponUser)user, stack)) {
                    this.crossbowState = CrossbowState.CHARGED;
                    this.mob.m_6136_(false);
                }
            }
        }
        if (target != null) {
            if (this.crossbowState == CrossbowState.CHARGED) {
                if (this.attackDelay == 0) {
                    this.attackDelay = 10;
                }
                --this.attackDelay;
                if (this.attackDelay == 0) {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && this.seeTime > 0) {
                this.mob.m_6504_(target, 1.0f);
                behavior.release(stack);
                this.crossbowState = CrossbowState.UNCHARGED;
            }
        }
    }

    @Override
    public void performRangedAttack(HumanoidGolemEntity golem, LivingEntity target, float power, ItemStack stack, InteractionHand hand) {
        WeaponRegistry.CROSSBOW.get((LivingEntity)this.mob, stack).ifPresent(e -> e.performRangedAttack((CrossbowUseContext)new GolemUser(golem, target), stack, hand));
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

